/* eslint-disable import/prefer-default-export */
import fly from '@/jslibs/dk-flyio'

const qs = require('qs')

// 获取活动列表
export const getActivityList = params => fly.get('mini/activity/activities', params)
// 轮播图列表
export const getActivityBanners = params => fly.get('mini/activity/banners', params)
// 活动详情
export const getActivityDetails = params => fly.get(`/mini/activity/details/${params}`)
// 项目列表
export const getProjectList = params => fly.get('mini/activity/region-activity/projects', params)
export const getProjectTemp = params => fly.get('mini/activity/projects-temp', params)
// 收藏/取消
export const upCollect = params => fly.put('mini/activity/user/collect', qs.stringify(params))
// 评论列表
export const getCommonList = params => fly.get('mini/activity/leave-notes', params)
// 评论点赞
export const onUserLikes = params => fly.post('mini/activity/activity-apply-user-likes', params)
// 评论详情
export const getCommonDetails = params => fly.get(`mini/activity/leave-notes/${params}`)
// 发表评论
export const sendCommon = params => fly.post('mini/activity/activity-leave-notes', params)
// 相册列表
export const getPictureList = params => fly.get('mini/activity/leave-picture', params)
// 发布相册
export const sendPicture = params => fly.post('/mini/activity/activity-picture-list', params)
// 报名活动详情
export const getUserActivitiesDetail = params => fly.get(`mini/activity/apply-user-details/activity-uuid/${params}`)
// 确认报名
export const applyUser = params => fly.post('mini/activity/activity-apply-user', params)
// 修改报名
export const upApplyUser = params => fly.put('mini/activity/activity-apply-user', params)
// 取消报名
export const cancelApply = params => fly.put('mini/activity/user/cancel', qs.stringify(params))
// 收藏活动列表
export const getCollectList = params => fly.get('mini/account/user-collect-activities', params)
// 活动报名列表
export const getApplyList = params => fly.get('mini/account/user-apply-activities', params)
// 活动报名取消理由
export const getApplyReasonList = params => fly.get('/mini/activity/cancel-reasons', params)
// 用户签到
export const userSignIn = params => fly.put('mini/activity/user/sign-in', qs.stringify(params))
// 相册点赞
export const getlikepicture = params => fly.put(`mini/activity/user/like-picture?${params}`)
// 活动问卷详情
export const getFormDetails = params => fly.get(`mini/activity/form-details/${params}`)
// 提交问卷
export const sendFormDetails = params => fly.post('mini/activity/form-user-record', params)
// 优惠券
export const getCouponsList = params => fly.get('mini/activity/coupons', params)
// 用户推送优惠券
export const pushMessage = params => fly.get(`mini/account/user-push-message/${params}`)
// 删除相册
export const deletePhoto = params => fly.delete(`/mini/activity/activity-picture-temp/${params}`)
// 浮窗
export const getTips = params => fly.get('/mini/activity/banners/type', params)
// 获取轮播图信息（视频）
export const getBannerVideo = params => fly.get('/mini/merchant/user/merchant-banner/banner-type', params)
// 获取闸机icon
export const getGateType = params => fly.get(`/mini/activity/banners/gate-type/${params}`)
