const fs = require('fs')
const path = require('path')
const router = require('./index.js')

// 将子路由模块配置文件转化为 uniapp 配置文件格式---pages
const buildRouter = route => {
  let res = []
  const { baseUrl, children } = route
  res = builder(baseUrl, children)
  return res
}
// 将子路由模块配置文件转化为 uniapp 配置文件格式---subPackages
const buildsubPackages = subPackages => {
  const res = []
  subPackages&&subPackages.forEach(item => {
    let obj  = {
      root: item.root,
      pages: builder('',item.pages),
    }
    res.push(obj)
  })
  return res
}

// 兼容pages
function builder(baseUrl,children){
  const res = []

  children.forEach(i => {
    if (i.children) {
      builder(baseUrl + i.path + '/', i.children)
    } else {
      const obj = {
        path: baseUrl + i.path,
        style: {
          navigationBarTitleText: i.name
        }
      }
      Object.keys(i).forEach(ii => {
        !['path', 'name'].includes(ii) && (obj.style[ii] = i[ii])
      })
      res.push(obj)
    }
  })
  return res
}
// 自动加载 './modules' 目录子路由配置文件
const getRouter = (file_array) => {
  let router = []
  file_array.forEach(r => {
    const route = require(r)
    router = [ ...router, ...buildRouter(route)]
  })
  return router
}
// 自动加载 './modules' 目录子路由配置文件
const getsubPackages = (file_array) => {
  let subPackages = []
  file_array.forEach(r => {
    const route = require(r)
    subPackages = [ ...subPackages, ...buildsubPackages(route.subPackages)]
  })
  return subPackages
}

const getFile = (srcPath) => {
  const result = fs.readdirSync(srcPath)
  let file = []
  result.forEach(r => {
    const path = srcPath + '/' + r
    const stat = fs.lstatSync(path)
    const is_file = stat.isFile()
    const is_directory = stat.isDirectory()
    if (is_file) { // 是文件
      file.push(path)
    }
    if (is_directory) {
      const file_array = getFile(path) // 递归查询子文件夹
      file = file.concat(file_array)
    }
  })
  return file
}

// 构建 pages 并写入 pages.json 文件
const srcPath = path.resolve(__dirname, './modules')
const file_array = getFile(srcPath) // 递归查询所有modules下的文件
router.pages = getRouter(file_array)
router.subPackages = getsubPackages(file_array)
// console.log('router.pages',router.pages);
fs.writeFile(
  __dirname + '/../pages.json',
  // 我这边是用两个空格来缩进 pages.json，如果喜欢制表符，第三个参数更换你为 \t 即可
  JSON.stringify(router, null, '  '),
  e => e ? console.error(e) : console.log('pages.json 配置文件更新成功')
)
