import Vue from 'vue';
import App from '@/App';
import store from '@/store'; // 状态管理
import common from '@/mixin/common' // 全局函数
import globalData from '@/utils/global-data';
import MpvueRouterPatch from './static/index'; // 路由拦截

Vue.use(MpvueRouterPatch);
Vue.config.productionTip = false;

Vue.mixin(common)
Vue.prototype.globalData = globalData


const app = new Vue({
  mpType: 'app',
  store,
  ...App,
});
app.$mount();
