/* eslint-disable import/prefer-default-export */
import fly from '@/jslibs/dk-flyio'

const qs = require('qs')

// 获取商家列表
export const getMerchantsList = params => fly.get('mini/merchant/merchants', params)
// 获取商家分类
export const getMerchantType = params => fly.get('mini/merchant/merchant-type', params)
// 获取优惠列表
export const getCouponsType = params => fly.get('mini/merchant/coupons-type', params)
// 商家详情
export const getMerchantDetail = params => fly.get(`mini/merchant/details/${params}`)
// 使用商家优惠
export const recordMerchant = params => fly.put('mini/merchant/user/merchant-record', qs.stringify(params))
// 商家记录列表
export const getUserRecordList = params => fly.get('mini/account/user-merchants-record', params)
// 获取首页轮播图
export const getMerchantIndexImg = params => fly.get('/mini/merchant/user/merchant-banner', params)
// 获取模块信息
export const getMerchantModel = params => fly.get(`/mini/merchant/user/merchant-model/${params}`)
// 获取榜单列表
export const getRankingList = params => fly.get('/mini/merchant/user/merchant-ranking', params)
// 获取商家信息
export const getUserMerchants = params => fly.get('/mini/merchant/user/merchants', params)
// 获取详情轮播图
export const getMerchantDetailImg = params => fly.get('/mini/merchant/user/model-banners', params)
// 获取区域项目列表
export const getProjectsList = params => fly.get('/mini/activity/region/projects', params)
