import React, { useState, useCallback, useEffect } from "react";
import { Button } from "antd";
import "./index.scss";
import {bookingV2Urls,factoryContentUrls } from "../../../config";
interface User {
    userNick: string,
    cookie:string,
    token:string
  }
const WayBillModel = function () {
    // 当前是否连接成功
    const [link,setLink] = useState<boolean>(false)
    // 当前的登录状态
    const [is_login,setIsLogin] = useState<boolean>(false)
    // 用户信息
    const [user,setUser] = useState<User>({
      userNick: '',
      cookie:'',
      token:''
    })
    // 获取发货易快递模板列表
    const getLogin = useCallback(async () => {
        chrome.tabs.query({
            url: [...bookingV2Urls,...factoryContentUrls]
        }, async function (tabs) {
            console.log('tabs',tabs);
            if(!tabs||!tabs.length){
              setLink(false)
             console.log('未连接')
            }else{
              setLink(true)
                // let urls = tabs.map(item=>item.url)
                // if(urls.includes('https://myseller.taobao.com/*')&&urls.includes('*://*.rtxmdz.com/*')){
                //   setLink(true)
                // }
            }
        })
    }, [])


    useEffect(() => {
        getLogin()
        // 获取用户信息
        chrome.storage.sync.get("tb_user",function(res){
            console.log(res);
            
            let userData = res.tb_user
            if (userData == null) {
                setIsLogin(false)
                setUser({userNick: '',
                cookie:'',
                token:''})
             } else {
                 let userDataJson:any = JSON.parse(userData)
                setIsLogin(true)
                setUser(userDataJson)
                setLink(true)
             }
        })
    }, [])

    // 刷新连接状态
    const refresh = useCallback(() => {
        getLogin()
        chrome.runtime.sendMessage({ action: 'getUserLoginData' },async()=>{
           let userData:any = await getStorageItem("tb_user")
           console.log('userData',userData,new Date().getMinutes(),new Date().getSeconds());
           if (userData == null) {
              setIsLogin(false)
              setUser({userNick: '',
              cookie:'',
              token:''})
           } else {
               let userDataJson:any = JSON.parse(userData)
              setIsLogin(true)
              setUser(userDataJson)
              setLink(true)
           }
        })
        // alert("刷新完毕");
    }, [])
    return (
        <>
            <div className="waybill-model">
                <div className="waybill-model-title" key="one">千牛登录账号：{is_login?user.userNick:'未登录'}</div>
                <div className="waybill-model-title" key="two">通信状态：{link?'连接成功':'连接中断'}</div>
            </div>
            <Button type="link" onClick={ refresh }>刷新连接状态</Button>
        </>
    )
}
function getStorageItem(key:string) {
    return new Promise((resolve, reject) => {
        chrome.storage.sync.get([key], (item) => {
            resolve(item[key]);
        })
    })

}
export default WayBillModel