import React,{ useCallback, useContext, useEffect, useState } from "react";
import { Checkbox } from "antd";
import { platformObj } from "../../../types";

const IsAutoEmit = function () {
     let [checkObj, setChecked] = useState<any>({})
     
    const changeRadio = useCallback((e,name:string) => {
        const obj = {...checkObj,[name]:e.target.checked}
        setChecked(obj)
    }, [checkObj])
    useEffect(() => {
        chrome.storage.local.get({ checkOptionObj: platformObj }, function (res) {
            // console.log('checkOptionObj',res.checkOptionObj);
            setChecked(res.checkOptionObj)
        })
    }, [])
    useEffect(() => {
        // console.log('checkOptionObj11111111',checkObj);
        chrome.storage.local.set({checkOptionObj:checkObj})
    },[checkObj])
    return <>
        <span className="waybill-panel-title">自动发货设置</span>
        <span className="waybill-panel-title">旧版发货易</span>
        <Checkbox checked={checkObj['jiu-taobao']} onChange={ (e) =>changeRadio(e,'jiu-taobao') } style={ { marginLeft: "13px" } }>淘宝-打印成功后自动发货</Checkbox>
        <Checkbox checked={checkObj['jiu-pdd']}  onChange={ (e) =>changeRadio(e,'jiu-pdd')  } style={ { marginLeft: "13px" } }>拼多多-打印成功后自动发货</Checkbox>
        <span className="waybill-panel-title">新版发货易</span>
        <Checkbox checked={checkObj['xin-taobao']}  onChange={ (e) =>changeRadio(e,'xin-taobao')  } style={ { marginLeft: "13px" } }>淘宝-打印成功后自动发货</Checkbox>
        <Checkbox  checked={checkObj['xin-pdd']} onChange={ (e) =>changeRadio(e,'xin-pdd')  } style={ { marginLeft: "13px" } }>拼多多-打印成功后自动发货</Checkbox>
        <Checkbox  checked={checkObj['xin-dy']} onChange={ (e) =>changeRadio(e,'xin-dy') } style={ { marginLeft: "13px" } }>抖音-打印成功后自动发货</Checkbox>
        <Checkbox  checked={checkObj['xin-other']}  onChange={ (e) =>changeRadio(e,'xin-other')  } style={ { marginLeft: "13px" } }>其他-打印成功后自动发货</Checkbox>
    </>
}

export default IsAutoEmit