// ScanPrintingForm对象默认绑定在 window["scan-printing-form"]

// 可以在发货易js加载之前增加事件回调,可以保证获取到ScanPrintingForm对象
// window.addEventListener("onSEScanPrintingFormLoad", () => {
//   const scanPrintingForm = window["scan-printing-form"];
// });

/**
 * 扫描打印数据加载完成回调函数
 */
type OnLoadCallbackFunction = (data: OnLoadData) => void;

/**
 * 扫描打印数据加载完成回调数据
 */
interface OnLoadData {
  waybillTemplates: WaybillTemplate[];

  shippingAddresses: ShippingAddress[];

  printers: Printer[];
}

interface ScanPrintingForm {
  /**
   * 增加数据加载成功回调方法
   * 使用示例
   * ```
   * scanPrintingForm.onLoad((data)=>{
   *    const { waybillTemplates, shippingAddresses, printers } = data;
   *
   * })
   * ```
   */
  onLoad(callbackFn: OnLoadCallbackFunction): void;

  /**
   * 配置表单
   */
  config(params: ConfigParams): Result;

  /**
   * 发送扫描打印任务
   */
  searchAndPrint(value: string): Result;
}

interface Result {
  successful: boolean;

  message: string;
}

/**
 * 扫描打印类型
 */
enum ScanPrintSearchType {
  /**
   * 使用订单编号
   */
  ORDER_ORIGINAL_ID = "ORDER_ORIGINAL_ID",

  /**
   * 使用运单号
   */
  WAYBILL_NO = "WAYBILL_NO",
}

/**
 * 获取运单号方式
 */
enum GetWaybillNoMethod {
  /**
   * 使用新单号
   */
  NEW = "NEW",
  /**
   * 使用旧单号
   */
  OLD = "OLD",
}

/**
 * 发货方式
 */
enum ShippingWay {
  /**
   * 自己联系物流
   */
  OFFLINE = "OFFLINE",
  /**
   * 在线下单
   */
  ONLINE = "ONLINE",
}

/**
 * 快递单模板打印类型
 */
interface ConfigParams {
  /**
   * 扫描类型
   */
  searchType: ScanPrintSearchType;

  /**
   * 是否避免重复扫描打印
   */
  checkRepeatPrint: boolean;

  /**
   * 快递单模板id
   */
  waybillTemplateId: number;

  /**
   * 打印机名称
   */
  printer: string;

  /**
   * 发货人id
   */
  shippingAddressId: number;

  /**
   * 是否打印成功后自动发货
   */
  autoShippingAfterPrint: boolean;

  /**
   * 获取面单方式
   */
  getWaybillNoMethod: GetWaybillNoMethod;

  /**
   * 发货方式
   */
  shippingWay?: ShippingWay;
}

/**
 * 快递单模板的类型
 */
enum WaybillTemplateType {
  CAINIAO = "CAINIAO",

  JD = "JD",

  JDL = "JDL",

  NORMAL = "NORMAL",

  OFFICIAL = "OFFICIAL",

  PDD = "PDD",

  JINRITEMAI = "JINRITEMAI",

  TAOBAO_CAINIAO = "TAOBAO_CAINIAO",
}

/**
 * 快递单模板
 */
interface WaybillTemplate {
  allowedShopIds?: string;

  allowedShopIdsArray?: string[];

  bindingPrinter: string;

  bindingShopIds: string;

  companyId: number;

  customAreaHeight?: number;

  customAreaLeft: number;

  customAreaPrintTemplateUrl: string;

  customAreaTop: number;

  customAreaWidth?: number;

  defaultShippingAddressId: number;

  deleted: boolean;

  enableEmptyShortAddressCheck: boolean;

  /**
   * 只有电子面单才有此字段
   * 申请地址id
   */
  ewaybillShippingAddressId: number;

  forceNoPageMargins: boolean;

  height: number;

  id: number;

  index: number;

  is3PartsWaybill: boolean;

  isPrintBottomLogo: boolean;

  isPrintTopLogo: boolean;

  isSystemTemplate: boolean;

  logisticsCompany: LogisticsCompany;

  name: string;

  offsetLeft: number;

  offsetTop: number;

  picture: string;

  printTemplateId: string;

  printTemplateUrl: string;

  printType: WaybillTemplatePrintType;

  serviceOptions: string;

  shopId: number;

  supportsChildWaybillNoMode: boolean;

  systemTemplateId: number;

  thumbnail: string;

  type: WaybillTemplateType;

  width: number;
}

/**
 * 快递单模板打印类型
 */
enum WaybillTemplatePrintType {
  CAINIAO = "CAINIAO",

  JDL = "JDL",

  PDD = "PDD",

  /**蓝牙打印 */
  PRINT_CMD = "PRINT_CMD",

  JINRITEMAI = "JINRITEMAI",
}

/**
 * 快递公司类型
 */
enum LogisticsCompany {
  /**中通快递 */
  ZTO = "ZTO",

  /**中通快运 */
  ZTO56 = "ZTO56",

  /**圆通速递 */
  YTO = "YTO",

  /**申通快递 */
  STO = "STO",

  /**韵达速递 */
  YUNDA = "YUNDA",

  /**韵达快运 */
  YUNDA56 = "YUNDA56",

  /**中国邮政 */
  POST = "POST",

  /**邮政快递包裹 */
  POSTB = "POSTB",

  /**邮政标准快递 */
  POSTS = "POSTS",

  /**EMS */
  EMS = "EMS",

  /**顺丰速运 */
  SF = "SF",

  /**顺丰快运 */
  SFKY = "SFKY",

  /**极兔速递 */
  JT = "JT",

  /**天天快递 */
  TTKDEX = "TTKDEX",

  /**宅急送 */
  ZJS = "ZJS",

  /**百世快递 */
  HTKY = "HTKY",

  /**百世快运 */
  BESTQJT = "BESTQJT",

  /**百世物流 */
  BEST = "BEST",

  /**众邮快递 */
  ZY = "ZY",

  /**京东快运 */
  JDKY = "JDKY",

  /**丰网速运 */
  FENGWANG = "FENGWANG",

  /**安能快递 */
  ANE66 = "ANE66",

  /**安能物流 */
  ANE56 = "ANE56",

  /**京东快递 */
  JD_EXPRESS = "JD_EXPRESS",

  /**京东大件物流 */
  JD_HPCP = "JD_HPCP",

  /**德邦物流 */
  DBL = "DBL",

  /**德邦快递 */
  DBKD = "DBKD",

  /**韵达国际 */
  YUNDAGJ = "YUNDAGJ",

  /**韵达同城 */
  YUNDA_TC = "YUNDA_TC",

  /**申通快运 */
  STO56 = "STO56",

  /**申通国际 */
  STOGJ = "STOGJ",

  /**中通国际 */
  ZTOGJ = "ZTOGJ",

  /**国通快递 */
  GTO = "GTO",

  /**EMS经济快递 */
  EYB = "EYB",

  /**跨越速运 */
  KUAYUE = "KUAYUE",

  /**安鲜达 */
  EXFRESH = "EXFRESH",

  /**九曳供应链 */
  JIUYESCM = "JIUYESCM",

  /**优速快递 */
  UC = "UC",

  /**万象物流 */
  WXWL = "WXWL",

  /**全锋快递 */
  QFKD = "QFKD",

  /**龙邦快递 */
  LB = "LB",

  /**全一快递 */
  UAPEX = "UAPEX",

  /**快捷快递 */
  FAST = "FAST",

  /**天地华宇 */
  HOAU = "HOAU",

  /**品骏快递 */
  PJBEST = "PJBEST",

  /**如风达快递 */
  RFD = "RFD",

  /**远成快运 */
  YCKY = "YCKY",

  /**壹米滴答 */
  YMDD = "YMDD",

  /**速尔快递 */
  SURE = "SURE",

  /**速通物流 */
  SUT56 = "SUT56",

  /**中铁快运 */
  CRE = "CRE",

  /**亚风 */
  AIR = "AIR",

  /**佳吉快递 */
  CNEX = "CNEX",

  /**联邦快递 */
  FEDEX = "FEDEX",

  /**增益速递 */
  QRT = "QRT",

  /**加运美速递 */
  JYMWL = "JYMWL",

  /**信丰物流 */
  XFWL = "XFWL",

  /**大田物流 */
  DTW = "DTW",

  /**D速物流 */
  DSWL = "DSWL",

  /**承诺达特快 */
  CNDTK = "CNDTK",

  /**运通物流 */
  YTWL = "YTWL",

  /**长宇物流 */
  CYWL = "CYWL",

  /**新邦物流 */
  XBWL = "XBWL",

  /**联昊通 */
  LWT = "LWT",

  /**苏宁物流 */
  SNWL = "SNWL",

  /**能达速递 */
  NDSD = "NDSD",

  /**保宏物流 */
  BHWL = "BHWL",

  /**发网 */
  FW = "FW",

  /**长发 */
  CF = "CF",

  /**远长 */
  YC = "YC",

  /**东方汇 */
  DFH = "DFH",

  /**飞远配送 */
  FYPS = "FYPS",

  /**黑猫宅急便 */
  HMZJB = "HMZJB",

  /**E速宝 */
  ESB = "ESB",

  /**华强物流 */
  HQWL = "HQWL",

  /**安迅物流 */
  AXWL = "AXWL",

  /**中运全速 */
  TOPSPEED = "TOPSPEED",

  /**华企快运 */
  HUAQIEX = "HUAQIEX",

  /**丹鸟 */
  DN = "DN",

  /**都市节奏 */
  DSJZ = "DSJZ",

  /**宽昊物流 */
  KHWL = "KHWL",

  /**顺心捷达 */
  SXJD = "SXJD",

  /**京广速递 */
  SZKKE = "SZKKE",

  /**韵达点通达 */
  YUNDA_DTD = "YUNDA_DTD",

  /**百世云配 */
  BSYP = "BSYP",

  /**运通速运 */
  WTO = "WTO",

  /**沃埃家 */
  WOWVIP = "WOWVIP",

  /**菜鸟裹裹 */
  CN_GUOGUO = "CN_GUOGUO",

  /**淘特物流快递 */
  TTWLKD = "TTWLKD",

  /**速腾快递 */
  STE56 = "STE56",

  /**安得物流 */
  ANDE = "ANDE",

  /**百世国际 */
  BESTGJ = "BESTGJ",

  /**当当网 */
  DANGDANG = "DANGDANG",

  /**EWE全球快递 */
  EWE = "EWE",

  /**丰云配 */
  FYP = "FYP",

  /**高捷物流 */
  GJWL = "GJWL",

  /**空港宏远电商物流 */
  HYWL = "HYWL",

  /**卡行天下快运 */
  KXTX = "KXTX",

  /**日日顺 */
  RRS = "RRS",

  /**威盛快递 */
  WSKD = "WSKD",

  /**威时沛运 */
  WSPY = "WSPY",

  /**贝海国际速递 */
  XLOBO = "XLOBO",

  /**中远e环球 */
  ZYEHQ = "ZYEHQ",

  /**转运四方物流 */
  ZYSF = "ZYSF",

  /**卓志速运 */
  ZZSY = "ZZSY",

  /**其他 */
  OTHER = "OTHER",
}

/**
 * 发货人对象
 */
interface ShippingAddress {
  id: number;

  /**绑定的店铺列表 用,分割 */
  bindingShopIds: string;

  city: string;

  cityCode: number;

  district: string;

  districtCode: number;

  mobile: string;

  /**发货地址名称 */
  name: string;

  province: string;

  provinceCode: number;

  /**发货人姓名 */
  shipperName: string;

  street: string;

  telephone: string;

  zipCode: string;

  /**排序 */
  index: number;
}

/**
 * 打印机对象
 */
interface Printer {
  name: string;
}
