


import { message } from "antd";

import { ACTION } from "../types";

import BookingV2 from "./bookingV2"
type Params = {
    a: number // 运单号
    b: number
}
interface Message {
    action: "Print",
    value: Params
}
// web页面通信
let task_id:any = null
window.addEventListener("message",function(message:any){
    // console.log('web页面通信1',message,new Date());
    if(message.data.action == ACTION.task){
        window.postMessage({isResult:2},"*")
        task_id = message.data.value.task_id
        chrome.runtime.sendMessage(message.data,(ret)=>{
            // console.log(2222,ret,new Date().getTime(),new Date().getSeconds());
            window.postMessage({isResult:1,task_id:task_id,...ret},"*")
            console.log("message ret:1",task_id,ret,message.data);
        })
    }
})
//发货易页面

chrome.runtime.onMessage.addListener(function (message, sender, response) {
    console.log("发货易页面",message,sender);
    if (message.action === ACTION.task) {
        let result=null;
        (async () => {
            result = await BookingV2.booking(message.value);
            // console.log(2222,result,new Date().getTime(),new Date().getSeconds());
            response(result);
        })();
    }
    return true;
})

/**
 * 发货易content
 */

// window.addEventListener("message", function (msg) {
//     console.log('发货易content',msg,new Date());


// })


