

import {PlatformCode} from "./index"
let domEle = {
    divNav:document.getElementsByClassName("nav-link") as HTMLCollection,
    inputOrderId: "#originalIds",
    btnSearch: "#root > section > main > div > div > div > div.order-main > div.order-table-container > div.order-search-pane > div > div > div:nth-child(2) > button:nth-child(2)",
    checkBoxSelectAll: "#root > section > main > div > div > div > div.order-main > div:nth-child(3) > div:nth-child(2) > div.bottom-operation-bar > span:nth-child(1) > label > span.ant-checkbox > input",
    btnPrint: "#root > section > main > div > div > div > div.order-main > div:nth-child(3) > div:nth-child(2) > div.bottom-operation-bar > button.ant-btn.ant-btn-primary.ec-print-waybill-button.mr10",
    modalTips:"ant-modal-confirm-title",
    btnTipsConfirm:"ant-btn ant-btn-primary",
    spanWaybillTemplate: ():any=>document.getElementsByClassName("ant-modal-body")[0].getElementsByClassName("ant-select-selector")[0] ,
    divWaybillTemplateList: ():any=>document.getElementsByClassName("rc-virtual-list-holder-inner")[0] ,
    radioGetNewWaybill: ():any=>document.querySelector(".ant-modal-body input.ant-radio-input") ,
    inputWaybillNoOnly: ():any=>document.querySelector("#isGenerateWaybillNoOnly")  ,
    btnDialogPrint: ():any=>document.querySelector("div.ant-modal-footer button"),
    modalResult: "#printEwaybillResultDialog",
    tableResult: ():any=>document.querySelector("#ewaybill-result-table > div > div.ant-table-body > table"),
    btnClose: ():any=>document.querySelector("div.ant-modal-footer button:nth-child(3)") ,
}
async function booking(waybillTemplateTitle: string, orderNo: string,shopId:string) {
    let result = {
        status: 4,
        msg: "未找到店铺",
        data: [],
    }
    for(let navIter=0;navIter<domEle.divNav.length;navIter++){
        let aNav = domEle.divNav[navIter] as HTMLLinkElement;
        
        if(aNav.href.indexOf(shopId)>-1){
            result.status=0;
            result.msg="";
            if(aNav.className.indexOf("active")==-1){
                aNav.click();
            }
            break;
        }
    }

    if (result.status > 0) {
        return result;
    }
    result = await waitOrder();
    if (result.status > 0) {
        return result;
    }
    changeReactInputValue(document.querySelector(domEle.inputOrderId),orderNo)
    

    simulateMouseClick(document.querySelector(domEle.btnSearch));
    result = await waitOrder();
    if (result.status > 0) {
        return result;
    }


    simulateMouseClick(document.querySelector(domEle.checkBoxSelectAll));
    simulateMouseClick(document.querySelector(domEle.btnPrint));
    await delayDate(500);

    if(document.getElementsByClassName(domEle.modalTips).length>0){
 
        simulateMouseClick(document.getElementsByClassName(domEle.btnTipsConfirm)[3]);
    }

    result = await waitDialog();
    if (result.status > 0) {
        return result;
    }


    simulateMouseClick(domEle.spanWaybillTemplate());
    let waybillTemplateList= domEle.divWaybillTemplateList();

    for (let i = 0; i < waybillTemplateList.childNodes.length; i++) {
        let divItem = waybillTemplateList.childNodes[i] as any;
        if (divItem.innerText == waybillTemplateTitle) {

            simulateMouseClick(divItem);
            
            simulateMouseClick(domEle.radioGetNewWaybill());
            
            if (domEle.inputWaybillNoOnly().checked == false) simulateMouseClick(domEle.inputWaybillNoOnly());
            
            if(!domEle.inputWaybillNoOnly().checked ){
                result.status=5;
                result.msg="未选择仅获取电子面单";
                return result;
            }

            simulateMouseClick(domEle.btnDialogPrint());
            result = await waitPrintResult();


            if (result.status == 0) {
                let printReslut: any = {
                    success: 0,
                    count: domEle.tableResult().rows.length-1,
                    fail: 0,
                    list: []
                }
                for (let rowIter = 1; rowIter < domEle.tableResult().rows.length; rowIter++) {
                    let rowResult = domEle.tableResult().rows[rowIter].cells[2].innerText;
                    let rowInfo = domEle.tableResult().rows[rowIter].cells[1].childNodes[0].childNodes[0].childNodes[1].textContent;
                    let rowObject = {
                        info: rowInfo,
                        msg: rowResult,
                        success: 1,
                    }
                    if (domEle.tableResult().rows[rowIter].cells[2].innerHTML.indexOf('class="text-error"') > -1) {
                        printReslut.fail++;
                        rowObject.success = 0;

                    } else {
                        printReslut.success++;
                    }
                    printReslut.list.push(rowObject)
                }
                result.data = printReslut;
                console.log(result);

                simulateMouseClick(domEle.btnClose());
                return result;
            }


            break;

        }
    }

    result.msg = "未匹配快递单模板";
    result.status = 3;
    return result;

}


async function waitOrder() {
    let result = {
        status: 4,
        msg: "获取订单超时",
        data: [],
    }
    for (let i = 0; i < 10; i++) {
        await delayDate(1000);

        let loadingMask = document.querySelector("#root > section > main > div > div > div > div.order-main > div.order-table-container > div.loading-mark-container > div") as any;
        if (loadingMask.style.display=="none" ) {

            if (document.querySelector("#root > section > main > div > div > div > div.order-main > div.order-table-container > div.loading-mark-container > table > tbody > tr > td > div > div.mb10 > p")) {
                //无订单
                result.status = 2;
                result.msg = "无相关订单"
                return result;
            } else {
                result.status = 0;
                result.msg = ""
                return result;
            }
        }
    }
    return result;
}
async function waitDialog() {
    let result = {
        status: 4,
        msg: "获取打印按钮超时",
        data: [],
    }
    for (let i = 0; i < 10; i++) {
        await delayDate(1000);
        if (document.getElementsByClassName("ant-modal-content").length) {

            result.status = 0;
            result.msg = ""
            return result;
        }
    }
    return result;
}

async function waitPrintResult() {
    let result = {
        status: 4,
        msg: "获取打印结果超时",
        data: [],
    }
    for (let i = 0; i < 10; i++) {
        await delayDate(1000);
        if (domEle.tableResult()) {
            result.status = 0;
            result.msg = ""
            return result;
        }
    }
    return result;
}

function delayDate(time: number) {
    return new Promise((resolve, reject) => {
        setTimeout(() => {
            //console.log(‘开始执行‘)
            resolve("success");
        }, time);
    });
}
function changeReactInputValue(inputDom:any,newText:string){
	let lastValue = inputDom.value;
	inputDom.value = newText;
	let event = new Event('input', { bubbles: true });
    // @ts-ignore
	event.simulated = true;
	let tracker = inputDom._valueTracker;
	if (tracker) {
  	tracker.setValue(lastValue);
	}
	inputDom.dispatchEvent(event);
}


const mouseClickEvents = ['mousedown', 'click', 'mouseup'];
function simulateMouseClick(element:any){
  mouseClickEvents.forEach(mouseEventType =>
    element.dispatchEvent(
      new MouseEvent(mouseEventType, {
          view: window,
          bubbles: true,
          cancelable: true,
          buttons: 1
      })
    )
  );
}

export default {
    booking
}