import React,{ useCallback, useContext, useEffect, useState } from "react";
import { TimePicker  } from "antd";
import type { Moment } from 'moment';
import moment from 'moment';
const format = 'HH:mm';
const Timer = function () {
    const [value, setValue] = useState<Moment | null>(null);
    const [pro_value, setProValue] = useState<Moment | null>(null);

    const onChange = (time:any) => {
      setValue(time);
    };
    const onChangePro =(time:any) => {
        setProValue(time);
      };
    useEffect(() => {
        chrome.storage.local.get({ AutoTime:null,proAutoTime:null }, function (res) {
            console.log(res.AutoTime,res.proAutoTime);
            if(res.AutoTime){
                setValue(moment(res.AutoTime, 'HH:mm'))
                window.postMessage({AutoTime:res.AutoTime})
                // chrome.runtime.sendMessage({AutoTime:res.AutoTime})
            }
            if(res.proAutoTime){
                setProValue(moment(res.proAutoTime, 'HH:mm'))
                window.postMessage({proAutoTime:res.proAutoTime})
                // chrome.runtime.sendMessage({proAutoTime:res.proAutoTime})
            }
        })
    }, [])
    useEffect(() => {
        if(value){
            let time = moment(value).format('HH:mm')
            chrome.storage.local.set({AutoTime:time})
            window.postMessage({AutoTime:time})
            // chrome.runtime.sendMessage({AutoTime:time})
        }
        if(pro_value){
            let pro_time = moment(pro_value).format('HH:mm')
            chrome.storage.local.set({proAutoTime:pro_time})
            window.postMessage({proAutoTime:pro_time})
            // chrome.runtime.sendMessage({proAutoTime:pro_time})
        }
    },[value,pro_value])
    return <>
        <span className="waybill-panel-title">自动约单的时间间隔</span>
        <div className="picker"><TimePicker value={value} onChange={onChange} format={format}/></div>
        <span className="waybill-panel-title">自动生成生产图的时间间隔</span>
        <div className="picker"><TimePicker value={pro_value} onChange={onChangePro} format={format}/></div>
    </>
}

export default Timer