import { platformObj } from "../types";

let domEle = {
    inputOrderId: document.querySelector("#orderFilterPane > div > form > ul > li:nth-child(4) > input") as HTMLInputElement,
    btnSearch: document.querySelector("#searchOrderButton") as HTMLButtonElement,
    checkBoxSelectAll: document.querySelector("#orderTable > thead > tr > th:nth-child(1) > input[type=checkbox]") as HTMLInputElement,
    btnPrint: document.querySelector("#printWaybillButton") as HTMLButtonElement,
    selectWaybillTemplate: document.querySelector("#printWaybillDialog > div > div > div.modal-body > form > div:nth-child(2) > div > select") as HTMLSelectElement,
    radioGetNewWaybill: document.querySelector("#printWaybillDialog > div > div > div.modal-body > form > div.form-group.get-waybill-no-method-radios > div > label:nth-child(1) > input[type=radio]") as HTMLInputElement,
    inputWaybillNoOnly: document.querySelector("#printWaybillDialog > div > div > div.modal-body > form > div:nth-child(4) > div > div > label > input[type=checkbox]") as HTMLInputElement,
    btnDialogPrint: document.querySelector("#printWaybillDialog > div > div > div.modal-footer > button.btn.btn-primary.print-button") as HTMLButtonElement,
    modalResult: document.querySelector("#printEwaybillResultDialog") as HTMLDivElement,
    tableResult: document.querySelector("#printEwaybillResultDialog > div > div > div.modal-body > div.result-table-container > table") as HTMLTableElement,
    btnClose: document.querySelector("#printEwaybillResultDialog > div > div > div.modal-footer > button.btn.btn-default") as HTMLButtonElement,
    btnDeliver: document.querySelector("#printEwaybillResultDialog > div > div > div.modal-footer > button.btn.ship-now-btn") as HTMLButtonElement,
}
// 发货易订单类型：10淘宝；20拼多多；30分销淘宝；40分销拼多多；50分销抖店；60分销其他代发；
async function booking(wayCompanyId: string, orderNo: string,fhy_type:number) {
    let checkOptionObj = platformObj
    chrome.storage.local.get({ checkOptionObj: platformObj }, function (res) {
      console.log('旧版app',res.checkOptionObj);
      checkOptionObj = res.checkOptionObj
    })
    domEle.inputOrderId.value = orderNo;
    domEle.checkBoxSelectAll.checked = true;
    domEle.btnSearch.click();
    let result = {
        status: 0,
        msg: "",
        data: [],
    }
    result = await waitOrder();
    if (result.status > 0) {
        return result;
    }

    domEle.checkBoxSelectAll.click();


    domEle.btnPrint.click();

    result = await waitDialog();
    if (result.status > 0) {
        return result;
    }
    for (let i = 0; i < domEle.selectWaybillTemplate.options.length; i++) {
        if (domEle.selectWaybillTemplate.options[i].value == wayCompanyId) {
            domEle.selectWaybillTemplate.selectedIndex = i;
            domEle.radioGetNewWaybill.click();
            if (domEle.inputWaybillNoOnly.checked == false) domEle.inputWaybillNoOnly.click();


            domEle.btnDialogPrint.click();

            result = await waitPrintResult();


            if (result.status == 0) {
                let printReslut: any = {
                    success: 0,
                    count: domEle.tableResult.rows.length,
                    fail: 0,
                    list: []
                }
                let chooseIndex = 0
                let rowResultList:any = []
                for (let rowIter = 0; rowIter < domEle.tableResult.rows.length; rowIter++) {
                    let rowResult = domEle.tableResult.rows[rowIter].cells[2].innerText;
                    let rowInfo = domEle.tableResult.rows[rowIter].cells[1].innerText;
                    let rowObject = {
                        info: rowInfo,
                        msg: rowResult,
                        success: 1,
                    }
                    rowResultList.push(rowResult)
                    if (rowResult.indexOf("打印失败") > -1) {
                        printReslut.fail++;
                        rowObject.success = 0;
                    } else {
                        printReslut.success++;
                    }
                    printReslut.list.push(rowObject)
                }
                result.data = printReslut;
                // 如果所有的订单都打印失败则，等会再发货，关闭弹窗
                if(rowResultList.every((item:any)=>item.includes('打印失败'))){
                    chooseIndex = -1
                }
                
                // 等会再发货
                if(chooseIndex===-1){
                    console.log('等会再发货');
                    domEle.btnClose.click();
                }else{
                    if((fhy_type===10&&checkOptionObj['jiu-taobao'])||(fhy_type===20&&checkOptionObj['jiu-pdd'])){
                      // 马上发货
                      console.log('马上发货');
                      domEle.btnDeliver.click()
                    }else{
                       console.log('等会再发货');
                       domEle.btnClose.click();
                    }
                }
                return result;
            }


            break;

        }
    }

    result.msg = "未匹配快递单模板";
    result.status = 3;
    return result;

}


async function waitOrder() {
    let result = {
        status: 4,
        msg: "获取订单超时",
        data: [],
    }
    for (let i = 0; i < 10; i++) {
        await delayDate(1000);
        if (domEle.checkBoxSelectAll.checked != true) {

            if (document.getElementsByClassName("not-order-found").length > 0) {
                //无订单
                result.status = 2;
                result.msg = "无相关订单"
                return result;
            } else {
                result.status = 0;
                result.msg = ""
                return result;
            }
        }
    }
    return result;
}
async function waitDialog() {
    let result = {
        status: 4,
        msg: "获取打印按钮超时",
        data: [],
    }
    for (let i = 0; i < 10; i++) {
        await delayDate(1000);
        if (domEle.btnDialogPrint.disabled == false) {
            result.status = 0;
            result.msg = ""
            return result;
        }
    }
    return result;
}

async function waitPrintResult() {
    let result = {
        status: 4,
        msg: "获取打印结果超时",
        data: [],
    }
    for (let i = 0; i < 10; i++) {
        await delayDate(1000);
        if (domEle.modalResult.className == 'modal fade sui-modal none in') {
            result.status = 0;
            result.msg = ""
            return result;
        }
    }
    return result;
}

function delayDate(time: number) {
    return new Promise((resolve, reject) => {
        setTimeout(() => {
            //console.log(‘开始执行‘)
            resolve("success");
        }, time);
    });
}
export default {
    booking
}