
import { bookingV2Urls,tbIssueUrl } from "../config";
import axios from 'axios'
async function booking(info: any) {
    let default_info = JSON.parse(info.goods)
    const data = {catId: default_info.catId,jsonBody: JSON.stringify(default_info)}
    let userData:any = await getStorageItem("tb_user")
    let reqMsg = {
        msg:'',
        status:-200,
        task_id:''
    };
    if(!userData){
        reqMsg.msg = "请刷新连接";
        return
    }
    let userDataJson:any = JSON.parse(userData)
    let {data:result} = await axios.post('https://item.upload.taobao.com/sell/v2/submit.htm', data, {
          headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
            'Accept':'application/json',
            'x-xsrf-token': userDataJson.token
          }
        })
        let rJson = result
            try {
             if (rJson.hasOwnProperty("ret")) {
                 if (JSON.stringify(rJson.ret).indexOf("被挤爆啦") != -1) {
                     let verifyUrl = rJson.data.url;
                     await openVerifyTab(verifyUrl);
                     await delayDate(1000 * 60);
                     reqMsg.msg = "请完成插件打开的页面提示验证码授权!";
                     reqMsg.status = -200;
                 }
             } else {
                 let rmg = rJson.models.globalMessage;
                 let rSuccessUrl = rmg.successUrl;
                 let rType = rmg.type;
                 reqMsg.status = rType == "status"?10:-200
                 if (rType != "status") {
                     let msg = JSON.stringify(rJson.models);
                     reqMsg.msg = msg;
                 } else {
                     let numIid = getUrlParam(rSuccessUrl, "primaryId");
                     reqMsg.task_id = numIid;
                 }
             }
              return reqMsg
            } catch (e) {
                reqMsg.msg = "发布错误,请重试或者联系客服咨询!";
                reqMsg.status = -200;
                return reqMsg
            }
}
async function bookingV2() {
    //     fetch("https://trade.taobao.com/trade/itemlist/seller_sold_notice.htm?positionCode=stopSpiderTB;stopSpiderTM;tjb;quickCollectFunds;buyOne",{method: "POST",mode:'no-cors'}).then(res => {
    //     console.log('fetch 111',res);
    //     resolve(res)
    //   })
    // })
}
function getStorageItem(key:string) {
    return new Promise((resolve, reject) => {
        chrome.storage.sync.get([key], (item) => {
            resolve(item[key]);
        })
    })

}
function getUrlParam(url:string, paramName:string){
    if (url.indexOf("?") != -1) {
        let params = url.split("?")[1].split("&");
        for (let i in params) {
            if (params[i].indexOf(paramName) != -1) {
                return params[i].replace(paramName + '=', '');
            }
        }
    }
    return '';
}

function delayDate(time: number) {
    return new Promise((resolve, reject) => {
      setTimeout(() => {
        //console.log(‘开始执行‘)
        resolve('status')
      }, time)
    })
  }
 async function openVerifyTab(url:string) {
    chrome.tabs.create({ url: url, active: true }, async (tab) => {
        alert("请手动完成系统自动打开的页面验证码操作!")
    })

}
export default {
    booking,bookingV2
}