/**
 * @description 根据name/params/query判断两个路由对象是否相等
 * @param {*} route1 路由对象
 * @param {*} route2 路由对象
 */
export const routeEqual = (route1, route2) => {
  return route1.name === route2.name
  // 此处改变相同路由的判断方式,改为name相同即认为相同
  // const params1 = route1.params || {}
  // const params2 = route2.params || {}
  // const query1 = route1.query || {}
  // const query2 = route2.query || {}
  // return (route1.name === route2.name) && objEqual(params1, params2) && objEqual(query1, query2)
}

export function tree(list, name = 'name') {
  list.forEach(item => {
    item.label = item[name]
    for (var i = 1; i < item.le; i++) {
      if (i === 1) {
        item.label = ' ' + item.label
      }
      item.label = (i === item.le - 1 ? '└' : '─') + item.label
    }
  })
  return list
}

// 时间戳转yyyy-mm-dd
export function fmtDate(obj) {
  var date = new Date(obj)
  var y = 1900 + date.getYear()
  var m = '0' + (date.getMonth() + 1)
  var d = '0' + date.getDate()
  return y + '-' + m.substring(m.length - 2, m.length) + '-' + d.substring(d.length - 2, d.length)
}

export function treeData(data, pid) {
  const tree = []
  data.forEach(i => { // 递归
    if (i.pid === pid) {
      const children = treeData(data, i.id)
      if (children.length) {
        i.children = children
      }
      tree.push(i)
    }
  })
  return tree
}

// 根据页面路径获取页面栏目索引
export const getMenuTreeIndexByUrl = (url, menuTree) => {
  const list = []
  let menuTreeIndex = 0
  let menuTreeChildIndex = 0
  let navIndex = 0
  let leftMenuIndex = 0
  menuTree.forEach((one, oneIndex) => {
    if (one.children && one.children.length) {
      one.children.forEach((two, twoIndex) => {
        if (two.children && two.children.length) {
          two.children.forEach((three, threeIndex) => {
            // const itemUrl = three.url.match(/page(\S*).html/)[1]
            if (url === three.url) {
              menuTreeIndex = oneIndex
              menuTreeChildIndex = twoIndex
              navIndex = threeIndex
              leftMenuIndex = (menuTreeChildIndex + 1) + '-' + (navIndex + 1)
            }
          })
        } else {
          if (url === two.url) {
            menuTreeIndex = oneIndex
            menuTreeChildIndex = twoIndex
            leftMenuIndex = (menuTreeChildIndex + 1).toString()
          }
        }
      })
    }
  })
  return { menuTreeIndex, menuTreeChildIndex, navIndex, leftMenuIndex }
}

export function parseTime(time, cFormat) {
  if (arguments.length === 0) {
    return null
  }
  const format = cFormat || '{y}-{m}-{d} {h}:{i}:{s}'
  let date
  if (typeof time === 'object') {
    date = time
  } else {
    if (typeof time === 'string' && /^[0-9]+$/.test(time)) {
      time = parseInt(time)
    }
    if (typeof time === 'number' && time.toString().length === 10) {
      time = time * 1000
    }
    date = new Date(time)
  }
  const formatObj = {
    y: date.getFullYear(),
    m: date.getMonth() + 1,
    d: date.getDate(),
    h: date.getHours(),
    i: date.getMinutes(),
    s: date.getSeconds(),
    a: date.getDay()
  }
  // eslint-disable-next-line
  const time_str = format.replace(/{(y|m|d|h|i|s|a)+}/g, (result, key) => {
    let value = formatObj[key]
    // Note: getDay() returns 0 on Sunday
    if (key === 'a') {
      return ['日', '一', '二', '三', '四', '五', '六'][value]
    }
    if (result.length > 0 && value < 10) {
      value = '0' + value
    }
    return value || 0
  })
  // eslint-disable-next-line
  return time_str
}

/**
 * 判断是否为空对象
 * @param {*} object 源对象
 */
export function isEmptyObject(object) {
  return Object.keys(object).length === 0
}

/**
 * 判断是否为对象
 * @param {*} object
 */
export function isObject(object) {
  return Object.prototype.toString.call(object) === '[object Object]'
}

/**
 * 判断是否为对象
 * @param {*} array
 */
export function isArray(array) {
  return Object.prototype.toString.call(array) === '[object Array]'
}

/**
 * 判断是否为空
 * @param {*} object 源对象
 */
export function isEmpty(value) {
  if (isArray(value)) {
    return value.length === 0
  }
  if (isObject(value)) {
    return isEmptyObject(value)
  }
  return !value
}
// 防抖
// 首次运行时把定时器赋值给一个变量， 第二次执行时，
// 如果间隔没超过定时器设定的时间则会清除掉定时器，
// 重新设定定时器， 依次反复， 当我们停止下来时，
// 没有执行清除定时器， 超过一定时间后触发回调函数。
export function debounce(fun, delay) {
  return function(args) {
    // 获取函数的作用域和变量
    const that = this
    const _args = args
    // 每次事件被触发，都会清除当前的timeer，然后重写设置超时调用
    clearTimeout(fun.id)
    fun.id = setTimeout(function() {
      fun.call(that, _args)
    }, delay)
  }
}
/**
 * 对象转url参数
 * @param {*} data
 * @param {*} isPrefix
 */
export function queryParams(data, isPrefix = '') {
  const _result = []
  for (const key in data) {
    const value = data[key]
    // 去掉为空的参数
    if (['', undefined, null].includes(value)) {
      continue
    }
    if (value.constructor === Array) {
      value.forEach(_value => {
        _result.push(encodeURIComponent(key) + '[]=' + encodeURIComponent(_value))
      })
    } else {
      _result.push(encodeURIComponent(key) + '=' + encodeURIComponent(value))
    }
  }
  return _result.length ? isPrefix + _result.join('&') : ''
}

// 导出数据的预处理函数
export function formatJson(filterVal, jsonData) {
  return jsonData.map(v => filterVal.map(j => {
    if (j instanceof Function) {
      return j(v)
    } else if (j === 'timestamp') {
      return parseTime(v[j])
    } else {
      let value = v[j]
      const re = /^([0-9]+\.?[0-9]*|-[0-9]+\.?[0-9]*)$/ // 正则判断如果是数字类型
      if (re.test(value)) {
        value = parseFloat(value)
      }
      return value
    }
  }))
}
