/* eslint-disable no-param-reassign,consistent-return */
/**
 * Created by IvanCai on 2017/4/19.
 */
import axios from 'axios'
// import Router from 'vue-router'
import { Message, MessageBox } from 'element-ui'

// const router = new Router({
//   mode: 'history'
// })

const apiDomain = process.env.api_domain
const service = axios.create({
  withCredentials: true,
  baseURL: apiDomain,
  timeout: 20000, // 设置超时时间
})

service.interceptors.request.use(
  (config) => {
    // if (window.showLoading) {
    //   window.showLoading()
    // }
    config.headers['X-Access-Token'] = sessionStorage.getItem('X-Access-Token') || 'd08ece6807f3ee81ee5178ca637d9082'
    return config
  },
  error => Promise.reject(error),
)

service.interceptors.response.use(
  (response) => {
    const data = response.data
    if (response.data.code !== '0') {
      if (data.code === 10000) {
        MessageBox.alert('登录过期，请重新登录', '提示', {
          confirmButtonText: '确定',
          callback: action => {
            window.location.replace('/login')
          }
        })
        return Promise.reject(response.data.error)
      }
      if (data.msg) {
        Message({
          message: data.msg,
          type: data.type || 'error',
        })
      }
      return Promise.reject(response.data.error)
    }
    return response.data
  },
  (error) => {
    // window.hideLoading()
    const { status, data } = error.response
    switch (status) {
      case 401:
      case 412:
        // 401或412说明token未传或失效，一般做重新登录操作
        // window.location.href = '/login'
        break
      case 500:
        // 后台服务器内部错误，一般向用户展示服务器错误信息
        window.showTips('服务器错误', 'error')
        break
      default:
        window.showTips('服务器错误', 'error')
        return Promise.reject(error)
    }
  },
)
export default service
