export const state = () => ({
  play: '',
  uiClick: '',
  uiClickType: '',
  mute: false, // 是否静音
  volumeMachine: 50, // 机器音量
  volumeBg: 50, // 背景音量
  volumeButton: 50, // 按钮音量
  videoPlay: false, // 是否曾经播放过
})

export const mutations = {
  SetAudioPlay: (state, data) => {
    state.play = new Date().getTime()
  },
  UiClick: (state, type = 'ui') => {
    state.play = new Date().getTime()
    state.uiClickType = type
    state.uiClick = new Date().getTime()
    state.videoPlay = true
  },
  // 设置静音
  SetMute: (state, data) => {
    state.mute = data
  },
  // 设置机器音量
  SetVolumeMachine: (state, data) => {
    state.volumeMachine = +data
    localStorage.setItem('volumeMachine', data)
  },
  // 设置背景音量
  SetVolumeBg: (state, data) => {
    state.volumeBg = +data
    localStorage.setItem('volumeBg', data)
  },
  // 设置按钮音量
  SetVolumeButton: (state, data) => {
    state.volumeButton = +data
    localStorage.setItem('volumeButton', data)
  },
  SetVideoPlay: (state, data) => {
    state.videoPlay = true
  },
}
