
// 常量：链接类型 - 页面
const LINK_TYPE_PAGE = 'PAGE'

// 基础页面
const basics = {
  title: '基础页面',
  key: 'basics',
  data: [
    {
      id: 'cb344ba',
      title: '商城首页',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/index'
      }
    },
    {
      id: 'c37c2ee',
      title: '新人指引',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/example/wxParse?key=xinrenyindao'
      }
    },
    {
      id: 'bb2f7f1',
      title: '奖金池',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/ranking?title=奖金池'
      }
    },
    {
      id: 'a013c669e',
      title: '常见问题',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages-user/user/FAQ'
      }
    },
    {
      id: 'a0132149e',
      title: '我的订单',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages-user/user/order/index?type=all'
      }
    },
    {
      id: 'a0233c9e',
      title: '我的收藏',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/user/colloct'
      }
    },
    {
      id: 'a01323e2342',
      title: '平台补贴',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages-user/user/balance/index?title=平台补贴'
      }
    },
    {
      id: 'a013c9e323',
      title: '我的余额',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages-user/user/balance/index?title=账户余额'
      }
    },
    {
      id: 'a013c9e2',
      title: '创业收入',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages-user/user/balance/index?title=创业收入'
      }
    },
    {
      id: 'a013c9e11',
      title: '我的会员',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages-user/user/VIP/index?tabIndex=0'
      }
    },
    {
      id: 'a013c9e12',
      title: '盲盒',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/blind/index'
      }
    },
    {
      id: 'a013c9e13',
      title: '拼团',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/newGroup',
        query: {
          type: 'spell'
        }
      }
    },
    {
      id: 'a013c9e14',
      title: '秒杀',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/seckill'
      }
    },
    {
      id: 'a013c9e15',
      title: '全额返',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/newGroup',
        query: {
          type: 'new_user_goods'
        }
      }
    },
    {
      id: 'pipipipi',
      title: '兑换商城',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/newGroup',
        query: {
          type: 'integral'
        }
      }
    },
    {
      id: 'hongbao',
      title: '抢红包',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/newGroup?type=hongbao'
      }
    },
    {
      id: 'goods',
      title: '百利返',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/newGroup',
        query: {
          type: 'goods'
        }
      }
    },
  ]
}

// 商城页面
const store = {
  title: '商城页面',
  key: 'store',
  data: [
    // {
    //   id: '995bf1c',
    //   title: '商品列表页',
    //   type: LINK_TYPE_PAGE,
    //   param: {
    //     path: 'pages/home/group',
    //     query: {
    //       type: 'goods'
    //     }
    //   },
    //   form: [
    //     {
    //       key: 'query.cateid',
    //       lable: '分类ID',
    //       tips: '商品管理 -> 商品分类'
    //     },
    //     // {
    //     //   key: 'query.search',
    //     //   lable: '关键词',
    //     //   tips: '搜索的关键词，用于匹配商品名称'
    //     // },
    //     {
    //       key: 'query.id',
    //       lable: '金刚区id',
    //       tips: '金刚区id'
    //     },
    //     // {
    //     //   key: 'query.image',
    //     //   lable: '图片',
    //     //   tips: '图片',
    //     //   component: 'image',
    //     // },
    //   ]
    // },
    {
      id: '995bf2c',
      title: '分类列表',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/classify/search',
      },
      form: [
        {
          key: 'query.cateId',
          lable: '分类ID',
          tips: '商品管理 -> 商品分类'
        },
      ]
    },
    {
      id: '995bf1c001',
      title: '礼包商品列表页',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/group',
        query: {
          name: 'is_new',
          type: 'bag',
        }
      }
    },
    {
      id: '995bf1c002',
      title: '新人专区',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pagesB/module/list/index',
      }
    },
    {
      id: '6wawb1000',
      title: '商品详情页',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/goods/detail',
        query: {
          type: 'goods'
        }
      },
      form: [
        {
          key: 'query.id',
          lable: '商品ID',
          required: true,
          // value: '10001',    // 默认值
          tips: '商品管理 - 商品列表' // 字段提示
        }
      ]
    },
    // 待开发
    {
      id: '6wawb10001',
      title: '拼团商品详情页',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/spell/detail',
      },
      form: [
        {
          key: 'query.id',
          lable: '商品ID',
          required: true,
          // value: '10001',    // 默认值
          tips: '商品管理 - 商品列表' // 字段提示
        }
      ]
    },
    {
      id: '6wawb10002',
      title: '全额返商品详情页',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/retFullMoney/detail',
      },
      form: [
        {
          key: 'query.id',
          lable: '商品ID',
          required: true,
          // value: '10001',    // 默认值
          tips: '商品管理 - 商品列表' // 字段提示
        }
      ]
    },
    {
      id: '6wawb10003',
      title: '抢红包商品详情页',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/redpacket/detail',
      },
      form: [
        {
          key: 'query.id',
          lable: '商品ID',
          required: true,
          // value: '10001',    // 默认值
          tips: '商品管理 - 商品列表' // 字段提示
        }
      ]
    },
    {
      id: '6wawb10004',
      title: '秒杀商品详情页',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/goods/detail',
        query: {
          type: 'goods'
        }
      },
      form: [
        {
          key: 'query.id',
          lable: '商品ID',
          required: true,
          tips: '商品管理 - 商品列表' // 字段提示
        },
        {
          key: 'query.next_time',
          lable: '结束时间',
          required: true,
          component: 'time',
          tips: '' // 字段提示
        },
      ]
    },
    {
      id: '6wawb10005',
      title: '积分商品详情页',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/integration/detail',
        query: {
          type: ''
        }
      },
      form: [
        {
          key: 'query.id',
          lable: '商品ID',
          required: true,
          // value: '10001',    // 默认值
          tips: '商品管理 - 商品列表' // 字段提示
        }
      ]
    },
    {
      id: '6wawb1051',
      title: '礼包商品详情页',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/home/goods/detail',
        query: {
          type: 'bag'
        }
      },
      form: [
        {
          key: 'query.id',
          lable: '商品ID',
          required: true,
          // value: '10001',    // 默认值
          tips: '商品管理 - 商品列表' // 字段提示
        }
      ]
    },
    // {
    //   id: '88lxeey',
    //   title: '商品搜索页',
    //   type: LINK_TYPE_PAGE,
    //   param: {
    //     path: 'pages/search/index'
    //   }
    // },
    // {
    //   id: '91th4ss',
    //   title: '自定义页',
    //   type: LINK_TYPE_PAGE,
    //   param: {
    //     path: 'pages/custom/index',
    //     query: {}
    //   },
    //   form: [
    //     {
    //       key: 'query.pageId',
    //       lable: '页面ID',
    //       required: true,
    //       tips: '店铺管理 -> 店铺页面'
    //     }
    //   ]
    // },
    // {
    //   id: '56sswhq',
    //   title: '领券中心',
    //   type: LINK_TYPE_PAGE,
    //   param: {
    //     path: 'pages/coupon/index'
    //   }
    // },
    // {
    //   id: 'ugrauzv',
    //   title: '文章列表页',
    //   type: LINK_TYPE_PAGE,
    //   param: {
    //     path: 'pages/article/index',
    //     query: {}
    //   },
    //   form: [
    //     {
    //       key: 'query.categoryId',
    //       lable: '分类ID',
    //       tips: '内容管理 -> 文章分类',
    //       value: ''
    //     }
    //   ]
    // },
    // {
    //   id: 'u1v6aux',
    //   title: '文章详情页',
    //   type: LINK_TYPE_PAGE,
    //   param: {
    //     path: 'pages/article/detail',
    //     query: {}
    //   },
    //   form: [
    //     {
    //       key: 'query.articleId',
    //       lable: '文章ID',
    //       required: true,
    //       tips: '内容管理 -> 文章列表'
    //     }
    //   ]
    // }
  ]
}

// 其他
const personal = {
  title: '个人中心',
  key: 'personal',
  data: [
    {
      id: '7b345f6',
      title: '我的订单',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/order/index',
        query: {}
      },
      form: [
        {
          key: 'query.dataType',
          lable: '订单类型',
          required: true,
          value: 'all', // 默认值
          tips: 'all 全部<br>payment 待支付<br>delivery 待发货<br>received 待收货' // 字段提示
        }
      ]
    },
    {
      id: '03b9290',
      title: '我的优惠券',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/my-coupon/index'
      }
    },
    {
      id: '0c25051',
      title: '收货地址',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/address/index'
      }
    },
    {
      id: '3558c27',
      title: '帮助中心',
      type: LINK_TYPE_PAGE,
      param: {
        path: 'pages/help/index'
      }
    }
  ]
}
// personal
export const linkList = [basics, store]
