import { Message } from 'element-ui'
import { getToken } from '@/utils/auth' // 验权
const whiteList = ['/loading', '/login', '/test', '/index/test', '/goToGame'] // 不重定向白名单

export default ({ app, redirect, route }) => {
  const { fullPath, path } = route
  const { store } = app
  const { relist } = store.state
  const token = getToken()

  if (fullPath === '/') { // 主页重定向到统计页面
    redirect(`/loading`)
  }
  if (!token || relist) {
    if (whiteList.indexOf(path) === -1) { // 如果当前路由需要鉴权
      redirect(`/login?redirect=${route.path}`)
    }
  } else {
    if (whiteList.indexOf(path) === -1) { // 如果当前路由需要鉴权
      // store.dispatch('IsLogin').then(res => { // 判断是否登录
      // }).catch(() => {
      //   redirect(`/login?redirect=${route.path}`)
      // })
    }
  }
}
