/**
 * Created by jiachenpan on 16/11/18.
 */
import { message } from '@/utils/resetMessage'

export function isvalidUsername(str) {
  const valid_map = ['admin', 'editor']
  return valid_map.indexOf(str.trim()) >= 0
}

export function isExternal(path) {
  return /^(https?:|mailto:|tel:)/.test(path)
}

// 验证身份证
export function checkIdNum(rule, value, callback) {
  const reg = /^[1-9]\d{7}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])\d{3}$|^[1-9]\d{5}[1-9]\d{3}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])\d{3}([0-9]|X)$/
  if (!value) {
    return callback(new Error('证件号码不能为空'))
  } else if (!reg.test(value)) {
    return callback(new Error('证件号码不正确'))
  } else {
    callback()
  }
}
// 验证手机号码
export function isIdcard(rule, value, callback) {
  const reg = /^[1][3,4,5,6,7,8,9][0-9]{9}$/
  if (!value) {
    return callback(new Error('手机号码不能为空'))
  } else if (!reg.test(value)) {
    return callback(new Error('手机号码不正确'))
  } else {
    callback()
  }
}
// 检验整数
export function isInteger(rule, value, callback) {
  const re = /^[1-9]\d*|0$/
  const rsCheck = re.test(value)
  if (!rsCheck) {
    callback(new Error('请输入正整数'))
  } else {
    callback()
  }
}
/**
 * 构造树型结构数据
 * @param {*} data 数据源
 * @param {*} id id字段 默认 'id'
 * @param {*} parentId 父节点字段 默认 'parentId'
 * @param {*} children 孩子节点字段 默认 'children'
 * @param {*} rootId 根Id 默认 0
 */
export function handleTree(data, id, parentId, children, rootId) {
  id = id || 'id'
  parentId = parentId || 'parentId'
  children = children || 'children'
  rootId = rootId || Math.min.apply(Math, data.map(item => { return item[parentId] })) || 0
  // rootId =  0
  // 对源数据深度克隆
  const cloneData = JSON.parse(JSON.stringify(data))
  // 循环所有项
  const treeData = cloneData.filter(father => {
    const branchArr = cloneData.filter(child => {
      // console.log('child-->',child);
      // 返回每一项的子级数组
      return father[id] === child[parentId]
    })

    branchArr.length > 0 ? father.children = branchArr : ''
    // 返回第一层
    return father[parentId] === rootId
  })

  return treeData !== '' ? treeData : data
}

// 表单验证弹窗
export function ruleErr(rules) {
  Object.keys(rules).forEach(key => {
    const item = rules[key]
    item.forEach((rule, i) => {
      if (i === 0) {
        const messages = rule.message
        message({
          message: messages,
          type: 'error',
        })
      }
    })
  })
}
