import md5 from 'js-md5'

import {
  LOGIN,
  GET_BASE_INFO,
  LOGOUT,
  IS_LOGIN,
  SET_TOKEN,
  SET_MENU_TREE,
  SET_AUTH_BTN_LIST,
  RELIST,
  SET_USER_INFO,
  SET_LOCALE,
  SET_META,
  SET_CACHE_NAV_LIST,
  DELETE_CACHE_NAV_LIST,
  CLOSE_ALL_CACHE_NAV_LIST,
  CLOSE_OTHER_CACHE_NAV_LIST,
  GET_CONFIG,
  SET_CONFIG,
} from '@/store/mutation-types'
import { treeData } from '@/utils/tool'
import { getToken, getImToken, removeToken, setUserData } from '@/utils/auth' // 验权

export const state = () => ({
  relist: false, // 重新登录
  userInfo: {}, // 用户信息
  cacheNavList: [], // 导航栏缓存的菜单
  menuTree: [], // 菜单数据（树状结构）
  menuList: [], // 菜单数据（列表结构）
  authBtnList: [], // 权限按钮列表
  authBtnIdList: [], // 权限按钮id列表
  deviceList: [], // 设备列表
  device: {}, // 当前设备
  topDeviceList: [], // 推荐设备列表
  token: getToken(),
  imToken: getImToken(),
  zoom: 1, // 当前屏幕缩放比例
  isMoblie: false,
  innerWidth: window.innerWidth,
  innerHeight: window.innerHeight,
  appConfig: {
    project_name: '——', // 项目名称
    img_domain: '', // 图片名称
  }, // app配置
  dictionary: {}, // 数据字典
  hideHeader: false, // 是否隐藏layout的header
  hidePage: false,
  ossConfig: {
    access_key: '',
    secret: '',
    region_id: '',
    bucket: '',
  }, // 阿里云配置
  jackpot: [], // jackpot信息
})

export const getters = {
  is_admin(state) { // 是否超级管理员
    return state.userInfo?.role_id === 1
  },
  is_mobile(state) {
    let is_mobile = false
    const { innerWidth, innerHeight, } = state
    const minWidth = 450
    if (innerWidth < minWidth || innerHeight < minWidth) {
      is_mobile = true
    }
    return is_mobile
  },
}

export const mutations = {
  [SET_TOKEN]: (state, token) => {
    state.token = token
  },
  // 重新登录
  [RELIST](state, data) {
    state.relist = data
  },

  // 退出登录
  [LOGOUT](state, isLogout) {
    state.menuTree = []
    state.userInfo = ''
    state.token = ''
    removeToken()
    if (!isLogout) {
      // 这里修改登录状态， index页面通过监听relist的状态来判断是否需要重新登录
      state.relist = true
    }
  },

  // 设置用户信息
  [SET_USER_INFO](state, data) {
    state.userInfo = data
  },

  [SET_LOCALE](state, locale) {
    state.locale = locale
  },

  [SET_META](state, meta) {
    state.meta = meta
  },

  [SET_CACHE_NAV_LIST](state, menu) {
    let isInclude = false
    state.cacheNavList.forEach((value) => {
      if (value.url === menu.url) isInclude = true
    })
    if (!isInclude) {
      state.cacheNavList.push(menu)
    }
  },

  // 缓存菜单数据
  [SET_MENU_TREE](state, list) {
    const menuList = JSON.parse(JSON.stringify(list))
    const treeMenuTree = treeData(list, 0)
    state.menuTree = treeMenuTree
    state.menuList = menuList
    state.authBtnList = menuList.filter(i => i.type === 'menu')
  },

  // 缓存菜单数据
  [SET_AUTH_BTN_LIST](state, list) {
    const menuList = JSON.parse(JSON.stringify(list))
    const menu = menuList.filter(i => i.type === 'menu')
    const authBtnIdList = []
    menu.forEach(item => {
      authBtnIdList.push(item.id)
    })
    state.authBtnIdList = authBtnIdList
  },

  [DELETE_CACHE_NAV_LIST](state, index) {
    const newList = state.cacheNavList.splice(index, 1)
  },

  [CLOSE_ALL_CACHE_NAV_LIST](state) {
    // 关闭所有,只保留第一个
    // const menu = state.cacheNavList[0]
    const newList = []
    // newList.push(menu)
    state.cacheNavList = newList
  },

  [CLOSE_OTHER_CACHE_NAV_LIST](state, index) {
    // 关闭其他,只保留当前一个
    const menu = state.cacheNavList[index]
    const newList = []
    newList.push(menu)
    state.cacheNavList = newList
  },

  // 保存配置信息
  [SET_CONFIG](state, data) {
    const { app, oss, dictionary } = data
    document.title = app.project_name
    state.ossConfig = oss
    state.appConfig = app
    state.dictionary = dictionary
  },

  SetImToken(state, data) {
    state.imToken = data
  },

  SetDeviceList(state, data) {
    state.deviceList = data
  },

  SetTopDeviceList(state, data) {
    state.topDeviceList = data
  },

  // 设置当前玩的游戏机
  SetDevice(state, data) {
    state.device = data
  },
  SetZoom(state, data) {
    state.zoom = data
  },
  SetInnerWidth(state, data) {
    // console.log('SetInnerWidth', data)
    state.innerWidth = data
  },
  SetInnerHeight(state, data) {
    // console.log('SetInnerHeight', data)
    state.innerHeight = data
  },
  SetHideHeader(state, data) {
    // console.log('SetInnerHeight', data)
    state.hideHeader = data
  },
  SetHidePage(state, data) {
    state.hidePage = data
  },
  SetJackpot(state, data) {
    state.jackpot = data
  },
}

export const actions = {
  [LOGIN]({ commit }, loginData) {
    const data = {
      ...loginData,
    }
    // return this.$request.post('/admin/login', data)
    return new Promise((resolve, reject) => {
      this.$request.post('/api/player/login', data).then(res => {
        const { data } = res
        const { token, openImToken, userId } = data
        commit(RELIST, false)
        commit('SetImToken', openImToken)
        setUserData({ token, openImToken, userId })
        resolve(res)
      }).catch(error => {
        reject(error)
      })
    })
  },
  [GET_BASE_INFO]({ commit }) {
    return new Promise((resolve, reject) => {
      this.$request.get('/api/player/user/getInfo').then(({ data }) => {
        commit('set_user_info', data) // 同时进行缓存
        resolve({ data })
      }).catch(error => {
        reject(error)
      })
    })
  },
  [GET_CONFIG]({ commit }) {
    return new Promise((resolve, reject) => {
      this.$request.get('/admin/getAdminConfig').then(({ data }) => {
        commit(SET_CONFIG, data)
        resolve({ data })
      }).catch(error => {
        reject(error)
      })
    })
  },
  [LOGOUT]({ commit }) {
    return new Promise((resolve, reject) => {
      this.$request.post('/admin/logout').then(res => {
        commit(LOGOUT, '')
        resolve(res)
      }).catch(error => {
        reject(error)
      })
    })
  },
  [IS_LOGIN]({ commit }) {
    return new Promise((resolve, reject) => {
      this.$request.get('/admin/isLogin').then(res => {
        resolve(res)
      }).catch(error => {
        reject(error)
      })
    })
  },
  GetDeviceList({ commit }) {
    return new Promise((resolve, reject) => {
      this.$request.get('/api/app/device/list').then(({ rows }) => {
        commit('SetDeviceList', rows)
        resolve(rows)
      }).catch(error => {
        reject(error)
      })
    })
  },
  GetTopDeviceList({ commit }) {
    return new Promise((resolve, reject) => {
      this.$request.get('/api/app/device/topDeviceList').then(({ data }) => {
        commit('SetTopDeviceList', data)
        resolve(data)
      }).catch(error => {
        reject(error)
      })
    })
  },
  GetJackpot({ commit }) {
    return new Promise((resolve, reject) => {
      this.$request({
        url: '/api/app/jackpot/list',
        method: 'get',
      }).then(({ data }) => {
        const list = data.filter(i => i.isMulti === 0)
        const compare = (property) => {
          return function(a, b) {
            var value1 = a[property]
            var value2 = b[property]
            return value2 - value1
          }
        }
        list.sort(compare('minAmount'))
        // setTimeout(() => {
        //   this.network().jackpot()
        // }, 1000)
        commit('SetJackpot', list)
        resolve(list)
      })
    })
  },
}
