import Vue from 'vue'

// 权限菜单
const authBtn = Vue.directive('authBtn', {
  // 当被绑定的元素插入到 DOM 中时……
  inserted: (el, binding, vnode) => {
    const { id } = el
    setTimeout(() => {
      const authBtnIdList = vnode.context.$store.state.authBtnIdList
      if (authBtnIdList.indexOf((Number)(id)) === -1) {
        el.parentNode.removeChild(el)
      }
    }, 300)
  },
  click: (el, binding) => {
    console.log('点击')
  },
})

export default { authBtn }
