import { Message, MessageBox } from 'element-ui'
import { getToken } from '@/utils/auth' // 验权

const service = ({ $axios, app }, inject) => {
  $axios.interceptors.request.use(
    (config) => {
      if (!config.url.includes('/api/player/login')) {
        config.headers['Authorization'] = getToken()
      }
      return config
    },
    error => Promise.reject(error),
  )

  $axios.interceptors.response.use(response => {
    const { data } = response
    const { code, msg, type } = data
    // console.log('响应拦截器', response.config.url)
    if (code !== 0) {
      if (code === 401) {
        app.store.commit('Logout')
        return Promise.reject(msg)
      }
      console.log('一般错误')
      if (msg) {
        Message({
          message: msg,
          type: type || 'error',
        })
      }
      return Promise.reject(msg)
    }
    return data
  }, error => {
    const { status, data, response } = error.response
    switch (status) {
      // case 401:
      // case 412:
      //   // 401或412说明token未传或失效，一般做重新登录操作
      //   // window.location.href = '/login'
      //   break
      // case 500:
      //   // 后台服务器内部错误，一般向用户展示服务器错误信息
      //   console.log('服务器错误')
      //   break
      default:
        console.log('服务器错误')
        return Promise.reject(error.response)
    }
  })
  inject('request', $axios)
}

export default service
