const { resolve } = require('path')
require('./configs')

const { baseURL, static_domain } = process.env
const { expandRouter } = require('./configs/buildConfig')
export default {
  mode: 'spa',
  /*
  ** Headers of the page
  */
  head: {
    title: process.env.project_name || '',
    meta: [
      { charset: 'utf-8' },
      { name: 'viewport', content: 'width=device-width, initial-scale=1' },
      { hid: 'description', name: 'description', content: process.env.project_description || '' }
    ],
    link: [
      { rel: 'icon', type: 'image/x-icon', href: '/favicon.ico' },
    ],
    script: [
    ],
  },
  env: process.env,
  /*
  ** Customize the progress-bar color
  */
  loading: { color: '#fff' },
  /*
  ** Global CSS
  */
  css: [
    'element-ui/lib/theme-chalk/index.css',
    '@/assets/styles/app.scss',
  ],
  /*
  ** Plugins to load before mounting the App
  */
  plugins: [
    // '@/plugins/element-ui',
    '@/plugins/plugins',
    { src: 'plugins/vuex-persistedstate.js', ssr: false },
    { src: '@/plugins/icons', ssr: true },
    { src: '@/plugins/axios', ssr: true },
    { src: '@/plugins/route', ssr: false },
    { src: './directive/permission', ssr: false }, // 按钮权限全局指令
    // '@/plugins/icons',
  ],
  /*
  ** Nuxt.js dev-modules
  */
  buildModules: [
  ],
  router: {
    middleware: ['auth'],
    ...expandRouter
  },
  /*
  ** Nuxt.js modules
  */
  modules: [
    '@nuxtjs/axios',
    // '@nuxtjs/proxy',
  ],
  /*
  ** Build configuration
  */
  build: {
    transpile: [/^element-ui/],
    /*
    ** You can extend webpack config here
    */
    extend (config, ctx) {
      // ...
      if (ctx.isDev && ctx.isClient) {
        config.module.rules.push({
          enforce: "pre",
          test: /\.(js|vue)$/,
          loader: "eslint-loader",
          exclude: /(node_modules)/
        })
      }

      const svgRule = config.module.rules.find(rule => rule.test.test('.svg'))
      svgRule.exclude = [resolve(__dirname, 'assets/icons/svg')]

      // Includes /icons/svg for svg-sprite-loader
      config.module.rules.push({
        test: /\.svg$/,
        include: [resolve(__dirname, 'assets/icons/svg')],
        loader: 'svg-sprite-loader',
        options: {
          symbolId: 'icon-[name]',
        },
      })
    }
  },
  axios: {
    // baseURL,
    proxy: true, // 表示开启代理
    prefix: process.env.NODE_ENV === 'development' ? '/api' : baseURL, // 表示给请求url加个前缀 /api
    credentials: true // 表示跨域请求时是否需要使用凭证
  },
  proxy: {
    '/api': {
      target: baseURL, // 目标接口域名
      changeOrigin: true, // 表示是否跨域
      pathRewrite: {
        '^/api': '/', // 把 /api 替换成 /
      }
    },
    '/static': {
      target: baseURL, // 设置调用接口域名和端口号别忘了加http
      changeOrigin: true,
      pathRewrite: {
        '^/api': '/', // 把 /api 替换成 /
      }
    }
  },
}
