import Cookies from 'js-cookie'

const TokenKey = 'user-token'
const UserId = 'user-id'
const OpenImToken = 'open-im-token'

export function getToken() {
  return Cookies.get(TokenKey)
}

export function setToken(token) {
  return Cookies.set(TokenKey, token)
}

export function setUserData({ token, userId, openImToken }) {
  Cookies.set(TokenKey, token)
  Cookies.set(UserId, userId)
  Cookies.set(OpenImToken, openImToken)
  return true
}

export function removeToken() {
  return Cookies.remove(TokenKey)
}
