import Vue from 'vue'

import indexMixins from '@/mixins/index.js' // 全局混入
Vue.mixin(indexMixins)

import VueClipboard from 'vue-clipboard2' // 复制组件
Vue.use(VueClipboard) // 复制组件

import {
  Message,
  Loading,
  Slider,
} from 'element-ui'

Vue.use(Loading.directive)
Vue.use(Slider)

Vue.prototype.$message = Message
Vue.prototype.$loading = Loading.service

Vue.filter('img', function(value) {
  return `${process.env.img_domain}${value}`
})
