import Vue from 'vue'

import indexMixins from '@/mixins/index.js' // 全局混入
Vue.mixin(indexMixins)

import VueClipboard from 'vue-clipboard2' // 复制组件
Vue.use(VueClipboard) // 复制组件

import {
  Message,
  Loading,
  Slider,
  Carousel,
  CarouselItem,
} from 'element-ui'

Vue.use(Loading.directive)
Vue.use(Slider)
Vue.use(Carousel)
Vue.use(CarouselItem)

Vue.prototype.$message = Message
Vue.prototype.$loading = Loading.service

Vue.filter('img', function(value) {
  return `${process.env.img_domain}${value}`
})

Vue.filter('filterToMoney', function(num) {
  if (typeof num !== 'number') {
    return num
  }
  num = num.toFixed(2)
  num = parseFloat(num)
  num = num.toLocaleString()
  return num // 返回的是字符串23,245.12保留2位小数
})

Vue.filter('filterToFen', function(num) {
  if (typeof num !== 'number') {
    return num
  }
  num = num.toFixed(2)
  const arr = (num + '').split('.')
  num = arr[0]
  const decimal = arr[1]
  num = parseFloat(num)
  num = num.toLocaleString()
  return num + '.' + decimal // 返回的是字符串23,245.12保留2位小数
})
